require(segmented)
require(reshape)

require(lattice)

require(epicalc)
setwd("XXXX/Data&Scripts")
load("phm_dsFoxodsUsp.RData")
load("dsFOXO.RData")
load("phm_dsFoxodsUspgrowth.RData")
load("dsFOXOgrowth.RData")

diff.CA<-NA
diff.CW<-NA
diff.TTP<-NA

theta=0.5*pi/180
R <- matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta)), nrow=2)
Rback <- matrix(c(cos(-theta), -sin(-theta), sin(-theta), cos(-theta)), nrow=2)

#assign data sheets to 'working' data sheets, one labelled A and the other B

dataA<-phm_dsFoxodsUsp
dataB<-dsFOXO
dataAgrowth<-phm_dsFoxodsUspgrowth
dataBgrowth<-dsFOXOgrowth

dataA$type<-"A"
dataAgrowth$type<-"A"
dataB$type<-"B"
dataBgrowth$type<-"B"

#merge data sheets for permutations
data<-rbind(dataA,dataB)
growth<-rbind(dataAgrowth,dataBgrowth)

for (i in 1:1000)
{
  perm.type <- sample(data$type, replace=F)
  permute<-data.frame("ttp"=data$ttp, "age"=data$age, "type"=perm.type)
  perm.A<-subset(permute, type=="A")
  perm.B<-subset(permute, type=="B")
  
  perm.type.growth<-sample(growth$type,replace=F)
  permute.growth<-data.frame("age"=growth$age, "mass"=growth$mass, "type"=perm.type.growth)
  perm.growth.A<-subset(permute.growth, type=="A")
  perm.growth.B<-subset(permute.growth, type=="B")
  
  #A CA,TTP and CW
  datam<-perm.A[c("age", "ttp")]
  datam<-as.matrix(datam)
  datamr<-datam%*%R
  datamrd<-as.data.frame(datamr)
  names(datamrd)<-c("age","ttp")
  glm<-glm(ttp~age, data=datamrd)
  seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
  bpage<-seg$psi[,2]
  slope<-seg$coefficients[2]
  intercept<-seg$coefficients[1]
  bpttp<-intercept+slope*bpage
  bpsunconverted <- matrix(c(bpage ,bpttp), ncol=2, nrow=1)
  CAandTTP<-bpsunconverted%*%Rback
  CAandTTP<-as.data.frame(CAandTTP)
  CA.A<-CAandTTP[,1]
  TTP.A<-CAandTTP[,2]

  lm<-lm(mass~age, data=perm.growth.A)
  int<-lm$coefficients[1]
  slp<-lm$coefficients[2]
  CW.A<-int+slp*CA.A    
  
  #B CA,TTP and CW
  datam<-perm.B[c("age", "ttp")]
  datam<-as.matrix(datam)
  datamr<-datam%*%R
  datamrd<-as.data.frame(datamr)
  names(datamrd)<-c("age","ttp")
  glm<-glm(ttp~age, data=datamrd)
  seg<-segmented(glm,seg.Z=~age,psi=list(age=10))
  bpage<-seg$psi[,2]
  slope<-seg$coefficients[2]
  intercept<-seg$coefficients[1]
  bpttp<-intercept+slope*bpage
  bpsunconverted <- matrix(c(bpage ,bpttp), ncol=2, nrow=1)
  CAandTTP<-bpsunconverted%*%Rback
  CAandTTP<-as.data.frame(CAandTTP)
  CA.B<-CAandTTP[,1]
  TTP.B<-CAandTTP[,2]
  
  lm<-lm(mass~age, data=perm.growth.B)
  int<-lm$coefficients[1]
  slp<-lm$coefficients[2]
  CW.B<-int+slp*CA.B
  
  perm.diff.CA<-CA.A-CA.B
  perm.diff.TTP<-TTP.A-TTP.B
  perm.diff.CW<-CW.A-CW.B
  
  diff.CA<-rbind(perm.diff.CA,diff.CA)
  diff.TTP<-rbind(perm.diff.TTP,diff.TTP)
  diff.CW<-rbind(perm.diff.CW,diff.CW)
}

diff.CA<-na.omit(diff.CA)
diff.CA<-as.vector(diff.CA)
diff.TTP<-na.omit(diff.TTP)
diff.TTP<-as.vector(diff.TTP)
diff.CW<-na.omit(diff.CW)
diff.CW<-as.vector(diff.CW)

#add the observed differences here

obsCA<-1.540453
obsTTP<-0.64317
obsCW<-0.18013

#Calculates the P values for the observed difference
# if P= 0 that means p=0.001 (because we did 1000 permutations)

N<-sum(diff.CA>=obsCA)+sum(diff.CA<=(-1*obsCA))
P<-(N)/1000
P

N<-sum(diff.TTP>=obsTTP)+sum(diff.TTP<=(-1*obsTTP))
P<-(N)/1000
P

N<-sum(diff.CW>=obsCW)+sum(diff.CW<=(-1*obsCW))
P<-(N)/1000
P


